/*------------------------------------------------------------------------------*
 * File Name:				 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2000, 2001, 2002, 2003, 2004, 2005, 2006, 2007		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/
 
 ///Sophy 9/29/2012 ORG-7026-P1 MATRIXPAGE_OVERLOADED_GETNAME_METHOD_READ_OCB_CRASH_WHEN_ARCHIVE
 //!!! need this in order to see string OriginObject::GetName, or else will only see PageBase::GetName(sring& strName), then will cause Archive exception(CLTArchive::ThrowException in VC) when compile OC and try to read from compiled OCB first.
 //as I see when compile the line mtNameList.AddString(pg.GetName());
#include <Origin.h>	
 ///end MATRIXPAGE_OVERLOADED_GETNAME_METHOD_READ_OCB_CRASH_WHEN_ARCHIVE
#include <data.h>
#include <Dialog.h>
#include <utilities.h>
#include <math.h> // rnd, exp
#include <stdio.h>
#include <project.h>

#include "nitestRes.h"


// Track modes.
enum TrackModes {
            // Generates mouse events only for the 
            // plot area.
            TrackPlotAreaEvents = 0,
            // Generates mouse events for plots and 
            // the plot area.
            TrackAllEvents      = 1,
            // Fire cursor events.
            TrackCursors        = 2,
            // Fire zoom, pan, rotate, and cursor events.
            TrackZoomPanRotate  = 20     
        };
       
// 3D plot styles.
enum PlotStyles {
            // Line
            Line              = 1,
            // Point
            Point             = 2,
            // Line-Point.
            LinePoint         = 3,
            // Hidden line.
            HiddenLine        = 4,
            // Surface.
            Surface           = 5,
            // Surface-Line.
            SurfaceLine       = 6,
            // Surface-Normal.
            SurfaceNormal     = 7,
            // Contour
            ContourLine       = 8,
            // Surface-Contour.
            SurfaceContour    = 9,          
        };
        
// Color map styles.
enum ColorMapStyles {
            // None
            None          = 0,
            // Shaded
            Shaded        = 1,
            // Color spectrum.
            ColorSpectrum = 2,
            // Grayscale
            GrayScale     = 3,
            // Custom
            Custom        = 4               
        };


static Dialog MyDlg(IDD_REGIONOFINTEREST_DIALOG, "NiTest");

bool NIROI() 
{
	MyDlg.DoModal();
	
	return true;
}

BEGIN_EVENT_MAP
	ON_INIT(OnInitDialog)
	ON_BN_CLICKED(IDC_RADIO_ROI, OnRadioRoi)
	ON_BN_CLICKED(IDC_RADIO_ZPR, OnRadioZpr)
	ON_LBN_SELCHANGE(IDC_LIST1, OnSelchangeList1)
	ON_ACTIVEX_EVENT(2, IDC_CWGRAPH3D, OnPlotMouseMoveCwgraph3d, VTS_CTRL VTS_PI2 VTS_PI2 VTS_PVARIANT VTS_PVARIANT VTS_PVARIANT VTS_PI2 VTS_PI4 VTS_PI4)
	ON_ACTIVEX_EVENT(1, IDC_CWGRAPH3D, OnPlotMouseDownCwgraph3d, VTS_CTRL VTS_PI2 VTS_PI2 VTS_PVARIANT VTS_PVARIANT VTS_PVARIANT VTS_PI2 VTS_PI4 VTS_PI4)
	ON_DESTROY(OnDestroy)

END_EVENT_MAP


static matrix zData(81,81);
static matrix zData2(81,81);
static long savedStartI, savedStartJ;

void GraphSourceData() 
{
	// Generate data
	ListBox mtNameList = MyDlg.GetItem(IDC_LIST1);
	
	MatrixPage	pg;
			
	// Loop over all the matrix pages in the project and display their names:
	foreach (pg in Project.MatrixPages)
	{
		mtNameList.AddString(pg.GetName());
	}
	
	for (long i = 0; i < zData.GetNumCols(); i++)
		for (long j = 0; j < zData.GetNumRows(); j++)
			zData[j][i] = sin(i / 4.0) * cos(j / 4.0) * sin(j / 13.0) * cos(i / 9.0);

	int nSize = mtNameList.GetCount();
	if ( nSize > 0 )
	{
		mtNameList.SetCurSel(0);
		string matrixName;
		mtNameList.GetText(0, matrixName);
		Matrix mat(matrixName);
		zData = mat;
		
	}
	// Plot the data
	Object m_Graph3D1 = MyDlg.GetItem(IDC_CWGRAPH3D).GetActiveXControl();
	m_Graph3D1.Plot3DSimpleSurface(zData);

	// Flatten out plot by increasingGraphSourceData z-axis extents
//    m_Graph3D1.GetAxes().Item("ZAxis").SetMinimum(-1.0);
//    m_Graph3D1.GetAxes().Item("ZAxis").SetMaximum(5.0);
    m_Graph3D1.Axes.Item("ZAxis").SetMinMax(-1.0, 5.0);

    // Set track mode to throw plot events
    m_Graph3D1.TrackMode = TrackAllEvents;
    Button m_RadioSelectROI = MyDlg.GetItem(IDC_RADIO_ROI);
	m_RadioSelectROI.Check = 1;
}

static void Swap(long & _first, long & _second)
{
	long temp = _first;
	_first = _second;
	_second = temp;
}


/////////////////////////////////////////////////////////////////////////////
// CRegionofInterestDlg message handlers


static BOOL OnInitDialog()
{	
	GraphSourceData();
	return TRUE;  // return TRUE  unless you set the focus to a control
}

//////////////////////////////////////////////////////////////////////////////
//	Event handlers
//////////////////////////////////////////////////////////////////////////////
												//VTS_CTRL VTS_PI2 VTS_PI2 VTS_PVARIANT VTS_PVARIANT VTS_PVARIANT VTS_PI2 VTS_PI4 VTS_PI4
static void OnPlotMouseMoveCwgraph3d(Control ctrl, short* pButton, short* Shift, _VARIANT& XX, _VARIANT& YY, _VARIANT& ZZ, short* PlotIndex, long* PointI, long* PointJ) 
{
	// If no button pressed don't do anything
	if (*pButton == 0)
		return;

	// Get the start and end indices and swap if necessary
	long startI = savedStartI;
	long startJ = savedStartJ;
	long endI = *PointI;
	long endJ = *PointJ;
	if (endI < startI)
		Swap(startI, endI);
	if (endJ < startJ)
		Swap(startJ, endJ);

	// Generate the region of interest data
	long sizeI = endI - startI + 1;
	long sizeJ = endJ - startJ + 1;
	zData2.SetSize(sizeI,sizeJ);

	for (int i = 0; i < sizeI; i++)
		for (int j = 0; j < sizeJ; j++)
			zData2[i][j] = zData[i + startI][j + startJ];

	// If we don't have a line reset the plot style and colormap style
	Object m_Graph3DROI = MyDlg.GetItem(IDC_CWGRAPHROI).GetActiveXControl();
	m_Graph3DROI.Plots.Item(1).ClearData();
	if ((startI != endI) && (startJ != endJ)) 
	{
		Object CWPlot1 = m_Graph3DROI.Plots(1);
		//m_Graph3DROI.Plots.Item(1).Style = Surface;
		CWPlot1.Style = Surface;
		//m_Graph3DROI.Plots(1).ColorMapStyle = Shaded;
		CWPlot1.ColorMapStyle = Shaded;
	}

	// Plot the data
	m_Graph3DROI.Plot3DSimpleSurface(zData2);
}
//VTS_CTRL VTS_PI2 VTS_PI2 VTS_PVARIANT VTS_PVARIANT VTS_PVARIANT VTS_PI2 VTS_PI4 VTS_PI4
static void OnPlotMouseDownCwgraph3d(Control ctrl, short *pButton, short * Shift, _VARIANT& XData, _VARIANT& YData, _VARIANT& ZData, short * PlotIndex, long * PointI, long * PointJ) 
{
	// Save the start indices
	savedStartI = *PointI;
	savedStartJ = *PointJ;	
}

static BOOL OnRadioRoi(Control ctrl) 
{
	// Change track mode to allow selecting a region of interest
	Object m_Graph3D1 = MyDlg.GetItem(IDC_CWGRAPH3D).GetActiveXControl();
	m_Graph3D1.TrackMode = TrackAllEvents;
	return TRUE;
}

static BOOL OnRadioZpr(Control ctrl) 
{
	// Change track mode to allow zooming, panning, and rotating of the left graph
	Object m_Graph3D1 = MyDlg.GetItem(IDC_CWGRAPH3D).GetActiveXControl();
	m_Graph3D1.TrackMode = TrackZoomPanRotate;
	return TRUE;
}

static BOOL OnSelchangeList1(Control ctrl) 
{
	ListBox mtNameList = MyDlg.GetItem(IDC_LIST1);
	int nIndex = mtNameList.GetCurSel();
	string matrixName;
	mtNameList.GetText(nIndex, matrixName);
	Matrix mat(matrixName);
	zData = mat;
	Object m_Graph3D1 = MyDlg.GetItem(IDC_CWGRAPH3D).GetActiveXControl();
	m_Graph3D1.Plot3DSimpleSurface(zData);
	return TRUE;
}

static BOOL OnDestroy(void)
{
	Button SaveCheckBox = MyDlg.GetItem(IDC_CHECK1);
	int nCheck = SaveCheckBox.Check;
	if ( 1 != nCheck )
		return TRUE;
	
	// Save data to a new matrix
	MatrixLayer mlay("Zoom");
	
	if(!mlay )
	{
		mlay.Create();
	}
	Matrix mm(mlay);
	mm = zData2;
		
	return TRUE;
}

